/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep.server;

import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.RUtils;
import com.ibm.hsc.rep.client.RQuery;
import com.ibm.hsc.rep.client.RResult;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Hashtable;

public class RxWorker
extends Thread {
    private Socket m_socket;

    public RxWorker(Socket socket) {
        this.m_socket = socket;
    }

    public void run() {
        System.out.println("RxWorker: socket=" + this.m_socket);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.m_socket.getOutputStream());
            ObjectInputStream objectInputStream = new ObjectInputStream(this.m_socket.getInputStream());
            while (true) {
                RQuery rQuery = (RQuery)objectInputStream.readObject();
                System.out.println("Client RQuery: " + rQuery);
                int n = rQuery.getQueryType();
                int n2 = RUtils.getNameSpaceId(rQuery.getNameSpace());
                RObjectId rObjectId = null;
                Object object = null;
                switch (n) {
                    case 0: 
                    case 1: {
                        int n3 = RUtils.getClassId(n2, rQuery.getClassName());
                        Hashtable hashtable = rQuery.getPropHash();
                        object = RUtils.queryMatched(n, n2, n3, hashtable);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        int n4 = RUtils.getAssoId(n2, rQuery.getAssoName());
                        rObjectId = (RObjectId)rQuery.getObjectId();
                        object = RUtils.queryRefs(n, n2, n4, rObjectId);
                        break;
                    }
                    case 4: {
                        rObjectId = (RObjectId)rQuery.getObjectId();
                        if (rObjectId == null) break;
                        object = rObjectId.getObject();
                        break;
                    }
                    case 5: {
                        RObject rObject;
                        rObjectId = (RObjectId)rQuery.getObjectId();
                        String string = rQuery.getPropName();
                        if (rObjectId == null || string == null || (rObject = rObjectId.getObject()) == null) break;
                        object = rObject.getProperty(string);
                    }
                }
                RResult rResult = new RResult();
                rResult.setRetVal(n, object);
                rResult.setSeqNum(rQuery.getSeqNum());
                objectOutputStream.writeObject(rResult);
                objectOutputStream.flush();
                System.err.println("Request handled");
            }
        }
        catch (EOFException eOFException) {
            System.err.println("RxWorker: EOF read");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println(iOException);
        }
        System.err.println("RxWorker: finished.");
    }
}

